% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v2_routes.R
\name{inegi_route}
\alias{inegi_route}
\title{Returns the route between two points in Mexico}
\usage{
inegi_route(from, to, token, pref, vehicle, calc_cost = FALSE,
  rawJSON = FALSE)
}
\arguments{
\item{from}{Destiny id from where the route begins}

\item{to}{Destiny id of end of route}

\item{token}{Sakbe API token supplied by INEGI}

\item{pref}{Preference for road: 1 = with tolls (cuota), 2 = without tolls (libre), 2 = suggested route}

\item{vehicle}{Vehicle choice: 0 = motorcycle, 1 = auto, 2 = two axis bus, 3 = three axis bus, 4 = four axis bus, 5 = two axis truck, 6 = three axis truck, 7 = four axis truck, 8 = five axis truck, 9 = six axis truck, 10 = seven axis truck, 11 = eight axis truck, 12 = nine axis truck.}

\item{calc_cost}{if TRUE will use the price of gasoline to calculate total cost of trip. Very experimental, defaults to FALSE.}

\item{rawJSON}{if TRUE returns only the JSON data, not parsed}
}
\value{
list
}
\description{
Uses SAKBE API to return a route between two destiny id's considering the given parameters.
}
\note{
To calculate the cost, it is wiser to use the more conservative estimate. Thus, this function assumes a premium type of gasoline (the most expensive) at the lower end bound of fuel-efficiency (11 kms per liter)
}
\examples{
# Macroplaza in Monterrey to Mexico City airport.
\dontrun{
token <- "webservice_token"
route <- inegi_route(from = 6940, to = 57, token, pref = 2, vehicle = 1)
}
}
\references{
See the official API here: http://www.inegi.org.mx/desarrolladores/sakbe/apisakbe.aspx
}
\author{
Eduardo Flores
}
