% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{chisq_test}
\alias{chisq_test}
\title{A tidier version of chisq.test for goodness of fit tests and tests of independence.}
\usage{
chisq_test(data, formula, ...)
}
\arguments{
\item{data}{a data frame that can be coerced into a \code{\link[tibble]{tibble}}}

\item{formula}{a formula with the response variable on the left and the explanatory on the right}

\item{...}{additional arguments for \code{chisq.test}}
}
\description{
A tidier version of chisq.test for goodness of fit tests and tests of independence.
}
\examples{
# chisq test for comparing number of cylinders against automatic/manual
  mtcars \%>\%
    dplyr::mutate(cyl = factor(cyl), am = factor(am)) \%>\%
    chisq_test(cyl ~ am)
}
