% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.visualization.R
\name{network.heatmap}
\alias{network.heatmap}
\title{The heatmap of network}
\usage{
network.heatmap(
  weightDT,
  switchMatrix = TRUE,
  heatmapSize = NULL,
  heatmapTitle = NULL,
  heatmapColor = NULL,
  showNames = FALSE,
  legendName = NULL
)
}
\arguments{
\item{weightDT}{The weight data table of network}

\item{switchMatrix}{switchMatrix}

\item{heatmapSize}{heatmapSize}

\item{heatmapTitle}{heatmapTitle}

\item{heatmapColor}{heatmapColor}

\item{showNames}{showNames}

\item{legendName}{legendName}
}
\value{
Return a heatmap of ggplot2 object
}
\description{
The heatmap of network
}
\examples{
library(inferCSN)
data("exampleMatrix")
data("exampleGroundTruth")
weightDT <- inferCSN(exampleMatrix)
p1 <- network.heatmap(exampleGroundTruth,
                      heatmapTitle = "Ground truth")

p2 <- network.heatmap(weightDT,
                      legendName = "Weight2",
                      heatmapTitle = "inferCSN")

ComplexHeatmap::draw(p1 + p2)

p3 <- network.heatmap(weightDT,
                      heatmapTitle = "inferCSN",
                      heatmapColor = c("#20a485", "#410054", "#fee81f"))

p4 <- network.heatmap(weightDT,
                      heatmapTitle = "inferCSN",
                      legendName = "Weight2",
                      heatmapColor = c("#20a485", "white", "#fee81f"))

ComplexHeatmap::draw(p3 + p4)

p5 <- network.heatmap(weightDT,
                      heatmapTitle = "inferCSN",
                      showNames = TRUE)
p5

}
