% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inferCSN.R
\docType{methods}
\name{inferCSN}
\alias{inferCSN}
\alias{inferCSN,matrix-method}
\alias{inferCSN,data.frame-method}
\title{Inferring Cell-Specific Gene Regulatory Network}
\usage{
inferCSN(
  object,
  penalty = "L0",
  algorithm = "CD",
  cross_validation = FALSE,
  seed = 1,
  n_folds = 10,
  percent_samples = 1,
  r_threshold = 0,
  regulators = NULL,
  targets = NULL,
  regulators_num = NULL,
  cores = 1,
  verbose = FALSE,
  ...
)

\S4method{inferCSN}{matrix}(
  object,
  penalty = "L0",
  algorithm = "CD",
  cross_validation = FALSE,
  seed = 1,
  n_folds = 10,
  percent_samples = 1,
  r_threshold = 0,
  regulators = NULL,
  targets = NULL,
  regulators_num = NULL,
  cores = 1,
  verbose = FALSE,
  ...
)

\S4method{inferCSN}{data.frame}(
  object,
  penalty = "L0",
  algorithm = "CD",
  cross_validation = FALSE,
  seed = 1,
  n_folds = 10,
  percent_samples = 1,
  r_threshold = 0,
  regulators = NULL,
  targets = NULL,
  regulators_num = NULL,
  cores = 1,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{object}{The input data for \code{inferCSN}.}

\item{penalty}{The type of regularization.
This can take either one of the following choices: \code{L0} and \code{L0L2}.
For high-dimensional and sparse data, such as single-cell sequencing data, \code{L0L2} is more effective.}

\item{algorithm}{The type of algorithm used to minimize the objective function.
Currently \code{CD} and \code{CDPSI} are supported.
The \code{CDPSI} algorithm may yield better results, but it also increases running time.}

\item{cross_validation}{Check whether cross validation is used.}

\item{seed}{The seed used in randomly shuffling the data for cross-validation.}

\item{n_folds}{The number of folds for cross-validation.}

\item{percent_samples}{The percent of all samples used for \code{\link{sparse.regression}}. Default set to 1.}

\item{r_threshold}{Threshold of \eqn{R^2} or correlation coefficient.}

\item{regulators}{A character vector with the regulators to consider for CSN inference.}

\item{targets}{A character vector with the targets to consider for CSN inference.}

\item{regulators_num}{The number of non-zore coefficients, this value will affect the final performance.
The maximum support size at which to terminate the regularization path.
Recommend setting this to a small fraction of min(n,p) (e.g. 0.05 * min(n,p)) as L0 regularization typically selects a small portion of non-zeros.}

\item{cores}{Number of CPU cores used. Setting to parallelize the computation with \code{\link[foreach]{foreach}}.}

\item{verbose}{Print detailed information.}

\item{...}{Parameters for other methods.}
}
\value{
A data table of gene-gene regulatory relationship
}
\description{
Inferring Cell-Specific Gene Regulatory Network
}
\examples{
data("example_matrix")
network_table <- inferCSN(example_matrix, verbose = TRUE)
head(network_table)

network_table <- inferCSN(example_matrix, cores = 2)
head(network_table)
}
