% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/one-samp-var-test.R
\name{os_vartest}
\alias{os_vartest}
\title{One Sample Variance Comparison Test}
\usage{
os_vartest(x, sd, confint = 0.95, alternative = c("both", "less", "greater",
  "all"), ...)
}
\arguments{
\item{x}{a numeric vector}

\item{sd}{hypothesised standard deviation}

\item{confint}{confidence level}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of "both" (default), "greater", "less" or "all". You can specify
just the initial letter}

\item{...}{additional arguments passed to or from other methods}
}
\value{
\code{os_vartest} returns an object of class \code{"os_vartest"}.
An object of class \code{"os_vartest"} is a list containing the
following components:

\item{n}{number of observations}
\item{sd}{hypothesised standard deviation of \code{x}}
\item{sigma}{observed standard deviation}
\item{se}{estimated standard error}
\item{chi}{chi-square statistic}
\item{df}{degrees of freedom}
\item{p_lower}{lower one-sided p-value}
\item{p_upper}{upper one-sided p-value}
\item{p_two}{two-sided p-value}
\item{xbar}{mean of \code{x}}
\item{c_lwr}{lower confidence limit of standard deviation}
\item{c_upr}{upper confidence limit of standard deviation}
\item{var_name}{name of \code{x}}
\item{conf}{confidence level}
\item{type}{alternative hypothesis}
}
\description{
\code{os_vartest} performs tests on the equality of standard
deviations (variances).It tests that the standard deviation of a sample is
equal to a hypothesized value.
}
\examples{
# lower tail
os_vartest(mtcars$mpg, 5, alternative = 'less')

# upper tail
os_vartest(mtcars$mpg, 5, alternative = 'greater')

# both tails
os_vartest(mtcars$mpg, 5, alternative = 'both')

# all tails
os_vartest(mtcars$mpg, 5, alternative = 'all')
}
\references{
Sheskin, D. J. 2007. Handbook of Parametric and Nonparametric
Statistical Procedures, 4th edition. : Chapman & Hall/CRC.
}
\seealso{
\code{\link[stats]{var.test}}
}

