% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{betweenness}
\alias{betweenness}
\alias{BC}
\title{Vertex betweenness centrality}
\usage{
betweenness(
  graph,
  v = V(graph),
  directed = TRUE,
  weights = NULL,
  normalized = FALSE,
  ...
)
}
\arguments{
\item{graph}{The graph to analyze (an igraph graph).}

\item{v}{The vertices for which the vertex betweenness will be calculated.}

\item{directed}{Logical, whether directed paths should be considered while determining the shortest paths.}

\item{weights}{Optional positive weight vector for calculating weighted betweenness.
If the graph has a weight edge attribute, then this is used by default. Weights are used to calculate weighted shortest paths, so they are interpreted as distances.}

\item{normalized}{Logical scalar, whether to normalize the betweenness scores. If TRUE, then the results are normalized.}

\item{...}{Additional arguments according to the original \code{\link[igraph]{betweenness}} function in the package igraph.}
}
\value{
A numeric vector with the betweenness score for each vertex in v.
}
\description{
This function and all of its descriptions have been obtained from the igraph package.
}
\examples{
\dontrun{
MyData <- coexpression.data
My_graph <- graph_from_data_frame(MyData)
GraphVertices <- V(My_graph)
My_graph_betweenness <- betweenness(My_graph, v = GraphVertices,
                        directed = FALSE, normalized = FALSE)
                        }
}
\seealso{
\code{\link[influential]{ivi}},
\code{\link[influential]{cent_network.vis}},
and \code{\link[igraph]{betweenness}} for a complete description on this function

Other centrality functions: 
\code{\link{clusterRank}()},
\code{\link{collective.influence}()},
\code{\link{degree}()},
\code{\link{h_index}()},
\code{\link{lh_index}()},
\code{\link{neighborhood.connectivity}()},
\code{\link{sirir}()}
}
\concept{centrality functions}
\keyword{betweenness_centrality}
