% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ceteris_paribus_2d.R
\name{ceteris_paribus_2d}
\alias{ceteris_paribus_2d}
\title{Ceteris Paribus 2D Plot}
\usage{
ceteris_paribus_2d(explainer, observation, grid_points = 101, variables = NULL)
}
\arguments{
\item{explainer}{a model to be explained, preprocessed by the \code{DALEX::explain()} function}

\item{observation}{a new observation for which predictions need to be explained}

\item{grid_points}{number of points used for response path. Will be used for both variables}

\item{variables}{if specified, then only these variables will be explained}
}
\value{
an object of the class \code{ceteris_paribus_2d_explainer}.
}
\description{
This function calculates ceteris paribus profiles for grid of values spanned by two variables.
It may be useful to identify or present interactions between two variables.
}
\examples{
library("DALEX")

model_titanic_glm <- glm(survived ~ age + fare,
                       data = titanic_imputed, family = "binomial")

\donttest{
explain_titanic_glm <- explain(model_titanic_glm,
                               data = titanic_imputed[,-8],
                               y = titanic_imputed[,8])

cp_rf <- ceteris_paribus_2d(explain_titanic_glm, titanic_imputed[1,],
                       variables = c("age", "fare", "sibsp"))
head(cp_rf)

plot(cp_rf)

library("randomForest")
set.seed(59)

apartments_rf_model <- randomForest(m2.price ~., data = apartments)

explainer_rf <- explain(apartments_rf_model,
                        data = apartments_test[,-1],
                         y = apartments_test[,1])

new_apartment <- apartments_test[1,]
new_apartment

wi_rf_2d <- ceteris_paribus_2d(explainer_rf, observation = new_apartment,
                               variables = c("surface", "floor", "no.rooms"))
head(wi_rf_2d)
plot(wi_rf_2d)
}

}
