% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_profiles.R
\name{cluster_profiles}
\alias{cluster_profiles}
\title{Cluster Ceteris Paribus Profiles}
\usage{
cluster_profiles(
  x,
  ...,
  aggregate_function = mean,
  variable_type = "numerical",
  center = FALSE,
  k = 3,
  variables = NULL
)
}
\arguments{
\item{x}{a ceteris paribus explainer produced with function \code{ceteris_paribus()}}

\item{...}{other explainers that shall be plotted together}

\item{aggregate_function}{a function for profile aggregation. By default it's \code{mean}}

\item{variable_type}{a character. If \code{numerical} then only numerical variables will be computed.
If \code{categorical} then only categorical variables will be computed.}

\item{center}{shall profiles be centered before clustering}

\item{k}{number of clusters for the hclust function}

\item{variables}{if not \code{NULL} then only \code{variables} will be presented}
}
\value{
an object of the class \code{aggregated_profiles_explainer}
}
\description{
This function calculates aggregates of ceteris paribus profiles based on
hierarchical clustering.
}
\details{
Find more detailes in the \href{https://pbiecek.github.io/ema/partialDependenceProfiles.html}{Clustering Profiles Chapter}.
}
\examples{
library("DALEX")

selected_passangers <- select_sample(titanic_imputed, n = 100)
model_titanic_glm <- glm(survived ~ gender + age + fare,
                         data = titanic_imputed, family = "binomial")

explain_titanic_glm <- explain(model_titanic_glm,
                               data = titanic_imputed[,-8],
                               y = titanic_imputed[,8])

cp_rf <- ceteris_paribus(explain_titanic_glm, selected_passangers)
clust_rf <- cluster_profiles(cp_rf, k = 3, variables = "age")
plot(clust_rf)

\donttest{
library("randomForest")
model_titanic_rf <- randomForest(survived ~.,  data = titanic_imputed)
model_titanic_rf

explain_titanic_rf <- explain(model_titanic_rf,
                              data = titanic_imputed[,-8],
                              y = titanic_imputed[,8],
                              label = "Random Forest v7")

cp_rf <- ceteris_paribus(explain_titanic_rf, selected_passangers)
cp_rf

pdp_rf <- aggregate_profiles(cp_rf, variables = "age")
head(pdp_rf)
clust_rf <- cluster_profiles(cp_rf, k = 3, variables = "age")
head(clust_rf)

plot(clust_rf, color = "_label_") +
  show_aggregated_profiles(pdp_rf, color = "black", size = 3)

plot(cp_rf, color = "grey", variables = "age") +
  show_aggregated_profiles(clust_rf, color = "_label_", size = 2)

clust_rf <- cluster_profiles(cp_rf, k = 3, center = TRUE, variables = "age")
head(clust_rf)
}
}
\references{
Explanatory Model Analysis. Explore, Explain and Examine Predictive Models. \url{https://pbiecek.github.io/ema}
}
