% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapper_repeat.R
\name{bru_mapper_repeat}
\alias{bru_mapper_repeat}
\alias{ibm_n.bru_mapper_repeat}
\alias{ibm_n_output.bru_mapper_repeat}
\alias{ibm_values.bru_mapper_repeat}
\alias{ibm_jacobian.bru_mapper_repeat}
\alias{ibm_eval.bru_mapper_repeat}
\alias{ibm_linear.bru_mapper_repeat}
\alias{ibm_invalid_output.bru_mapper_repeat}
\title{Mapper for repeating a mapper}
\usage{
bru_mapper_repeat(mapper, n_rep)

\method{ibm_n}{bru_mapper_repeat}(mapper, ...)

\method{ibm_n_output}{bru_mapper_repeat}(mapper, ...)

\method{ibm_values}{bru_mapper_repeat}(mapper, ...)

\method{ibm_jacobian}{bru_mapper_repeat}(mapper, input, state = NULL, ..., sub_lin = NULL)

\method{ibm_eval}{bru_mapper_repeat}(mapper, input, state, ..., sub_lin = NULL)

\method{ibm_linear}{bru_mapper_repeat}(mapper, input, state, ...)

\method{ibm_invalid_output}{bru_mapper_repeat}(mapper, input, state, ...)
}
\arguments{
\item{mapper}{The mapper to be repeated.}

\item{n_rep}{The number of times to repeat the mapper.}

\item{...}{Arguments passed on to other methods}

\item{input}{Data input for the mapper.}

\item{state}{A vector of latent state values for the mapping,
of length \code{ibm_n(mapper, inla_f = FALSE)}}

\item{sub_lin}{Internal, optional pre-computed sub-mapper information}
}
\value{
A \code{bru_mapper_repeat} object.
}
\description{
Defines a repeated-space mapper that sums the contributions for
each copy. The \code{ibm_n()} method returns \code{ibm_n(mapper) * n_rep}, and
\code{ibm_values()} returns \code{seq_len(ibm_n(mapper))}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{ibm_jacobian(bru_mapper_repeat)}: The input should take the format of the
repeated submapper.

\item \code{ibm_invalid_output(bru_mapper_repeat)}: Passes on the input to the corresponding method.

}}
\examples{
m <- bru_mapper_repeat(bru_mapper_index(3), 4)
ibm_n(m)
ibm_values(m)
ibm_jacobian(m, 1:3)
ibm_eval(m, 1:3, seq_len(ibm_n(m)))

}
\seealso{
\link{bru_mapper}, \link{bru_mapper_generics}

Other mappers: 
\code{\link{bru_get_mapper}()},
\code{\link{bru_mapper}()},
\code{\link{bru_mapper.fm_mesh_1d}()},
\code{\link{bru_mapper.fm_mesh_2d}()},
\code{\link{bru_mapper_aggregate}()},
\code{\link{bru_mapper_collect}()},
\code{\link{bru_mapper_const}()},
\code{\link{bru_mapper_factor}()},
\code{\link{bru_mapper_fmesher}()},
\code{\link{bru_mapper_generics}},
\code{\link{bru_mapper_harmonics}()},
\code{\link{bru_mapper_index}()},
\code{\link{bru_mapper_linear}()},
\code{\link{bru_mapper_logsumexp}()},
\code{\link{bru_mapper_marginal}()},
\code{\link{bru_mapper_matrix}()},
\code{\link{bru_mapper_mesh_B}()},
\code{\link{bru_mapper_multi}()},
\code{\link{bru_mapper_pipe}()},
\code{\link{bru_mapper_scale}()},
\code{\link{bru_mapper_shift}()},
\code{\link{bru_mapper_taylor}()}
}
\concept{mappers}
