% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgl.R
\name{glplot.SpatialPoints}
\alias{glplot.SpatialPoints}
\title{Visualize SpatialPoints using RGL}
\usage{
\method{glplot}{SpatialPoints}(object, add = TRUE, color = "red", ...)
}
\arguments{
\item{object}{a SpatialPoints or SpatialPointsDataFrame object.}

\item{add}{If TRUE, add the points to an existing plot. If FALSE, create new plot.}

\item{color}{vector of R color characters. See rgl.material() for details.}

\item{...}{Parameters passed on to rgl.points()}
}
\description{
This function will calculate the cartesian coordinates of the points provided
and use rgl.points() in order to render them.
}
\examples{
\dontrun{
if (bru_safe_inla() &&
  require("rgl", quietly = TRUE) &&
  require("sphereplot", quietly = TRUE)) {

  # Load pantropoical dolphin data

  data("mexdolphin", package = "inlabru")

  # Show the globe

  globe()

  # Add mesh, ship transects and dolphin sightings stored
  # as inla.mesh, SpatialLines and SpatialPoints objects, respectively

  glplot(mexdolphin$mesh)
  glplot(mexdolphin$samplers)
  glplot(mexdolphin$points)
}
}
}
\seealso{
Other inlabru RGL tools: 
\code{\link{globe}()},
\code{\link{glplot.SpatialLines}()},
\code{\link{glplot.inla.mesh}()},
\code{\link{glplot}()}
}
\concept{inlabru RGL tools}
