% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terms.R
\docType{data}
\name{terms}
\alias{terms}
\title{Term Frequency from INLPO Publications}
\format{
An object of class 'term' that inherits behavior from the 'data.frame' class
and includes the following columns:
\describe{
\item{\code{term}}{Term, a word or group of words,
represented by an ASCII character string in lowercase.}
\item{\code{pub_id}}{Identifier for a publication,
referes to the primry key of the \code{\link{pubs}} data table.}
\item{\code{freq}}{Frequency count from text analysis.}
}
}
\source{
The publication text was sourced from the original PDF documents using the \code{\link{extract_pdf_text}} function,
and term frequencies were extracted from the text using the \code{\link{mine_text}} function.
}
\usage{
terms
}
\description{
Term frequency from publications by the U.S. Geological Survey (USGS),
Idaho Water Science Center, Idaho National Laboratory Project Office (INLPO).
}
\examples{
str(terms, max.level = 3, width = 75, strict.width = "cut")
}
\keyword{datasets}
