% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{f_ll_mnl}
\alias{f_ll_mnl}
\title{Log-likelihood function of the (normally mixed) multinomial logit model}
\usage{
f_ll_mnl(theta, data, R = 100, neg = FALSE)
}
\arguments{
\item{theta}{The vector of model coefficients in order \code{c(b,o)}, see the details.}

\item{data}{A \code{data.frame} with the shape of the output of \code{\link{sim_mnl}}.}

\item{R}{The number of random draws to approximate the integral for the mixed logit
choice probabilities.}

\item{neg}{Set to \code{TRUE} to return the negative log-likelihood value.}
}
\value{
The log-likelihood value at \code{theta}.
}
\description{
Log-likelihood function of the (normally mixed) multinomial logit model
}
\details{
The order of \code{theta} is supposed to be \code{c(b,o)}, where
\itemize{
\item \code{b} denotes the coefficients
\item and \code{o} the lower-triangular elements of the lower-triangular
Cholesky root of \code{Omega} (if any).
}
}
\examples{
data <- sim_mnl(N = 300, J = 3, b = c(1,3), seed = 1)
theta <- attr(data, "true")
f_ll_mnl(theta = theta, data = data)
\donttest{
nlm(f_ll_mnl, p = theta, data = data, neg = TRUE)$estimate
}

}
\references{
https://en.wikipedia.org/wiki/Multinomial_logistic_regression
}
\seealso{
\code{\link[=sim_mnl]{sim_mnl()}} for simulating a data set from a logit model.
}
\keyword{function}
\keyword{internal}
