% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strategies.R
\name{fixed_initialization}
\alias{fixed_initialization}
\title{Fixed initialization}
\usage{
fixed_initialization(
  x,
  at,
  ncores = getOption("ino_ncores"),
  verbose = getOption("ino_progress"),
  label = "fixed"
)
}
\arguments{
\item{x}{An object of class \code{ino}.}

\item{at}{A numeric vector of length \code{npar(x)} with the (fixed) initial values.}

\item{ncores}{The number of cores for parallel computation over parameters and optimizers.
The default is \code{getOption("ino_ncores")}, which is set to \code{1}
when the package is loaded.}

\item{verbose}{A boolean, which indicates whether progress should be printed.
Set to \code{TRUE} (\code{FALSE}) to print (hide) progress.
The default is \code{getOption("ino_progress")}, which is set to \code{TRUE}
when the package is loaded.}

\item{label}{A character, the label for the initialization strategy.}
}
\value{
The updated \code{ino} object.
}
\description{
This function is an implementation of the fixed initialization strategy.
}
\seealso{
\code{\link[=npar]{npar()}} to extract the number \code{npar} from an \code{ino} object.
}
\keyword{strategy}
