% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy.R
\name{taxonomy}
\alias{taxonomy}
\title{Download taxonomy database.}
\usage{
taxonomy(db = "NCBI", synonyms = FALSE)
}
\arguments{
\item{db}{character string specifying which taxonomy database to download.
Currently only "NCBI" is supported.}

\item{synonyms}{logical indicating whether synonyms should be included.
Note that this increases the size of the returned object by around 10\%.}
}
\value{
a dataframe with the following elements:
  "taxID", "parent_taxID", "rank", "name".
}
\description{
This function downloads an up-to-date copy of the taxonomy database.
}
\details{
This function downloads the specified taxonomy database as a data.frame
  object with the following columns:
  "taxID", "parent_taxID", "rank", "name".
  As of early 2018 the zip archive to download the NCBI taxonomy database
  is approximately 40Mb in size, and the output dataframe object is around
  200Mb in memory. Once downloaded, the dataframe can be pruned
  for increased speed and memory efficiency using the function
  \code{\link{prune_taxonomy}}.
}
\examples{
\donttest{
  # db <- taxonomy()
}
}
\references{
Federhen S (2012) The NCBI Taxonomy database.
 \emph{Nucleic Acids Research}
 \strong{40}, D136-D143. doi:10.1093/nar/gkr1178.

 \url{https://www.ncbi.nlm.nih.gov/taxonomy/}
}
\author{
Shaun Wilkinson
}
