% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_insee_dataset.R
\name{get_insee_dataset}
\alias{get_insee_dataset}
\title{Get dataset from INSEE BDM database}
\usage{
get_insee_dataset(
  dataset,
  startPeriod = NULL,
  endPeriod = NULL,
  firstNObservations = NULL,
  lastNObservations = NULL,
  includeHistory = NULL,
  updatedAfter = NULL,
  filter = NULL
)
}
\arguments{
\item{dataset}{dataset name to be downloaded}

\item{startPeriod}{start date of data}

\item{endPeriod}{end date of data}

\item{firstNObservations}{get the first N observations for each key series (idbank)}

\item{lastNObservations}{get the last N observations for each key series (idbank)}

\item{includeHistory}{boolean to access the previous releases (not available on all series)}

\item{updatedAfter}{starting point for querying the previous releases (format yyyy-mm-ddThh:mm:ss)}

\item{filter}{Use the filter to choose only some values in a dimension. It is recommended to use it for big datasets.
A dimension left empty means all values are selected. To select multiple values in one dimension put a "+" between those values (see example)}
}
\value{
a tibble with the data
}
\description{
Get dataset from INSEE BDM database
}
\details{
Get dataset from INSEE BDM database
}
\examples{
\donttest{
insee_dataset = get_dataset_list()
idbank_ipc = get_idbank_list("IPC-2015")

#example 1
data = get_insee_dataset("IPC-2015", filter = "M+A.........CVS..", startPeriod = "2015-03")

#example 2
data = get_insee_dataset("IPC-2015", filter = "A..SO...VARIATIONS_A....BRUT..SO",
 includeHistory = TRUE, updatedAfter = "2017-07-11T08:45:00")
}

}
