% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sigma.R
\name{get_sigma}
\alias{get_sigma}
\title{Get residual standard deviation from models}
\usage{
get_sigma(x, ci = NULL, verbose = TRUE)
}
\arguments{
\item{x}{A model.}

\item{ci}{Scalar, the CI level. The default (\code{NULL}) returns no CI.}

\item{verbose}{Toggle messages and warnings.}
}
\value{
The residual standard deviation (sigma), or \code{NULL} if this information could not be accessed.
}
\description{
Returns \code{sigma}, which corresponds the estimated standard deviation of the residuals. This function extends the \code{sigma()} base R generic for models that don't have implemented it. It also computes the confidence interval (CI), which is stored as an attribute.

Sigma is a key-component of regression models, and part of the so-called auxiliary parameters that are estimated. Indeed, linear models for instance assume that the residuals comes from a normal distribution with mean 0 and standard deviation \code{sigma}. See the details section below for more information about its interpretation and calculation.
}
\details{
\subsection{Interpretation of Sigma}{
  The residual standard deviation, \ifelse{html}{\out{&sigma;}}{\eqn{\sigma}},
  indicates that the predicted outcome will be within +/- \ifelse{html}{\out{&sigma;}}{\eqn{\sigma}}
  units of the linear predictor for approximately 68\% of the data points
  (\cite{Gelman, Hill & Vehtari 2020, p.84}). In other words, the residual
  standard deviation indicates the accuracy for a model to predict scores,
  thus it can be thought of as \dQuote{a measure of the average distance
  each observation falls from its prediction from the model}
  (\cite{Gelman, Hill & Vehtari 2020, p.168}). \ifelse{html}{\out{&sigma;}}{\eqn{\sigma}}
  can be considered as a measure of the unexplained variation in the data,
  or of the precision of inferences about regression coefficients.
  }
  \subsection{Calculation of Sigma}{
  By default, \code{get_sigma()} tries to extract sigma by calling
  \code{stats::sigma()}. If the model-object has no \code{sigma()} method,
  the next step is calculating sigma as square-root of the model-deviance
  divided by the residual degrees of freedom. Finally, if even this approach
  fails, and \code{x} is a mixed model, the residual standard deviation is
  accessed using the square-root from \code{get_variance_residual()}.
  }
}
\examples{
data(mtcars)
m <- lm(mpg ~ wt + cyl + vs, data = mtcars)
get_sigma(m)
}
\references{
Gelman, A., Hill, J., & Vehtari, A. (2020). Regression and Other Stories. Cambridge University Press.
}
