% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_transformation.R
\name{get_transformation}
\alias{get_transformation}
\title{Return function of transformed response variables}
\usage{
get_transformation(x, include_all = FALSE, verbose = TRUE)
}
\arguments{
\item{x}{A regression model or a character string of the formulation of the
(response) variable.}

\item{include_all}{Logical, if \code{TRUE}, does not only check the response
variable, but all model terms.}

\item{verbose}{Logical, if \code{TRUE}, prints a warning if the transformation
could not be determined.}
}
\value{
A list of two functions: \verb{$transformation}, the function that was used to
transform the response variable; \verb{$inverse}, the inverse-function of
\verb{$transformation} (can be used for "back-transformation"). If no
transformation was applied, both list-elements \verb{$transformation} and
\verb{$inverse} just return \code{function(x) x}. If transformation is unknown,
\code{NULL} is returned.
}
\description{
This functions checks whether any transformation, such as log- or
exp-transforming, was applied to the response variable (dependent variable)
in a regression formula, and returns the related function that was used for
transformation. See \code{\link[=find_transformation]{find_transformation()}} for an overview of supported
transformations that are detected.
}
\examples{
# identity, no transformation
model <- lm(Sepal.Length ~ Species, data = iris)
get_transformation(model)

# log-transformation
model <- lm(log(Sepal.Length) ~ Species, data = iris)
get_transformation(model)

# log-function
get_transformation(model)$transformation(0.3)
log(0.3)

# inverse function is exp()
get_transformation(model)$inverse(0.3)
exp(0.3)

# get transformations for all model terms
model <- lm(mpg ~ log(wt) + I(gear^2) + exp(am), data = mtcars)
get_transformation(model, include_all = TRUE)
}
