% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_cmdstan_version.R
\name{stan_cmdstan_version}
\alias{stan_cmdstan_version}
\title{Version of CmdStan that \code{instantiate} uses.}
\usage{
stan_cmdstan_version(
  cmdstan_install = Sys.getenv("CMDSTAN_INSTALL"),
  error_on_NA = TRUE
)
}
\arguments{
\item{cmdstan_install}{Character of length 1, how CmdStan was installed. The
installation method determines how \code{instantiate} looks up CmdStan.
Set the default value with the \code{CMDSTAN_INSTALL} environment variable.
Choices:
\enumerate{
\item \code{"internal"}: Use the copy of CmdStan installed internally inside the
\code{instantiate} package file system. Before using this option,
CmdStan must be installed in the package file system. To do this,
set the \code{CMDSTAN_INSTALL} environment variable to \code{"internal"} before
installing \code{instantiate}.
\item \code{"fixed"}: Use the copy of CmdStan that was located at the value
contained in \code{Sys.getenv("CMDSTAN")} at the time \code{instantiate}
was installed. In this case, the path to CmdStan is not inside
\code{instantiate} itself, but it is fixed at installation time
and does not depend on the current value of
\code{Sys.getenv("CMDSTAN")} at runtime.
\item \code{"cmdstanr"}: Let the \code{cmdstanr::cmdstan_path()} decide where
to look for CmdStan. The \code{cmdstanr} package must be installed. If it
is not installed, the function returns the empty string \code{""}.
\item \code{""} (default): Try all 3 options in the order above to find a valid
installed copy of CmdStan.
}}

\item{error_on_NA}{(logical) Should an error be thrown if CmdStan is not
found. The default is \code{TRUE}. If \code{FALSE}, \code{cmdstan_version()} returns
\code{NULL}.}
}
\value{
Character of length 1, version of CmdStan that the \code{instantiate}
package uses. If CmdStan is not found, then the return value depends
on the \code{error_on_NA} argument.
}
\description{
Return the version of CmdStan that the \code{instantiate}
package uses.
}
\examples{
if (stan_cmdstan_exists()) {
  message(stan_cmdstan_version())
}
}
\seealso{
Other cmdstan: 
\code{\link{stan_cmdstan_exists}()}
}
\concept{cmdstan}
