% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tariff_classes.R
\name{autoplot.insurancerating}
\alias{autoplot.insurancerating}
\title{Automatically create a ggplot for objects obtained from construct_tariff_classes()}
\usage{
\method{autoplot}{insurancerating}(x, conf.int = FALSE,
  clusters = TRUE, color_gam = "steelblue", color_splits = "grey50",
  xstep = 10, add_points = FALSE, size_points = 1,
  color_points = "black")
}
\arguments{
\item{x}{an object as produced by \code{construct_tariff_classes()}}

\item{conf.int}{determines whether 95\% confidence intervals will be plotted. The default is \code{conf.int = FALSE}}

\item{clusters}{numerical vector with splits as produced by \code{construct_tariff_classes()}}

\item{color_gam}{a color can be specified either by name (e.g.: "red") or by hexadecimal code (e.g. : "#FF1234") (default is "steelblue")}

\item{color_splits}{change the color of the splits in the graph ("grey50" is default)}

\item{xstep}{set step size for horizontal axis (default is \code{10})}

\item{add_points}{add observed frequency/severity points for each level of the variable for which tariff classes are constructed}

\item{size_points}{size for points (1 is default)}

\item{color_points}{change the color of the points in the graph ("black" is default)}
}
\value{
a ggplot object
}
\description{
Takes an object produced by \code{construct_tariff_classes()}, and plots the predicted claim frequency.
In addition the constructed tariff classes are shown.
}
\examples{
library(ggplot2)
x <- construct_tariff_classes(MTPL, nclaims, age_policyholder, exposure)
autoplot(x)

}
\author{
Martin Haringa
}
