% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ciregic.R
\name{summary.ciregic}
\alias{summary.ciregic}
\title{Summary of \code{ciregic}}
\usage{
\method{summary}{ciregic}(object, ...)
}
\arguments{
\item{object}{an object of class \code{ciregic}, which is a result of a call to \code{ciregic}}

\item{...}{further arguments}
}
\value{
The function \code{\link[intccr]{summary.ciregic}} returns a list of summary statistics of the model from \code{object}.
\item{varnames}{a vector containing variable names}
\item{coefficients}{a vector of the regression coefficient estimates}
\item{se}{a bootstrap standard error of the coefficients}
\item{z}{z value of the estimated coefficients}
\item{p}{p value of the estimated coefficients}
\item{call}{a matched call}
}
\description{
\code{summary} method for class \code{ciregic}
}
\details{
The function \code{summary.ciregic} returns the coefficients, bootstrap standard errors, and etc. Additionally, 'significance star' is included.
}
\examples{
## Continuing the ciregic(...) example
\dontshow{
newdata <- dataprep(data = longdata, ID = "id", time = "t",
                    event = "c", Z = c("z1", "z2"))
fit <- ciregic(Surv2(v, u, c) ~ z1 + z2, data = newdata,
               alpha = c(1, 1), nboot = 0, do.par = FALSE)
}
sfit <- summary(fit)
sfit

}
\seealso{
The fitted semiparametric regression on cumulative incidence function with interval-censored competing risks data \code{\link[intccr]{ciregic}} and values of the predicted cumulative incidence functions \code{\link[intccr]{predict.ciregic}}
}
