% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ciregic_lt.R
\name{predict.ciregic_lt}
\alias{predict.ciregic_lt}
\title{Covariate-Specific Cumulative Incidence Prediction}
\usage{
\method{predict}{ciregic_lt}(object, covp, times, ...)
}
\arguments{
\item{object}{an object of class \code{ciregic_lt}, which is a result of a call to \code{ciregic_lt}}

\item{covp}{a desired values for covariates}

\item{times}{time points that user wants to predict value of cumulative incidence function}

\item{...}{further arguments}
}
\value{
The function \code{predict.ciregic_lt} returns a list of predicted values of the model from \code{object}.
\item{t}{time points}
\item{cif1}{the predicted value of cumulative incidence function for the event type 1}
\item{cif2}{the predicted value of cumulative incidence function for the event type 2}
}
\description{
\code{predict} method for class \code{ciregic_lt}. It provides the predicted cumulative incidence function for a given covariate pattern and timepoint(s).
}
\details{
\code{predict.ciregic_lt} returns the predicted cumulative incidence function for a given covariate pattern and timepoint(s).
}
\examples{
## Continuing the ciregic_lt(...) example
pfit <- predict(object = fit_lt, covp = c(1, 0.5), times = c(0.1, 0.15, 0.5, 0.7))
pfit
mint <- fit_lt$tms[1]
maxt <- fit_lt$tms[2]
pfit1 <- predict(object = fit_lt, covp = c(1, 0.5),
                 times = seq(mint, maxt, by = (maxt - mint) / 99))
plot(pfit1$t, pfit1$cif1, ylim = c(0, 1), type = "l")
lines(pfit1$t, pfit1$cif2, ylim = c(0, 1), lty = 2, col = 2)
}
\seealso{
The fitted semiparametric regression on cumulative incidence function with interval-censored competing risks data \code{\link[intccr]{ciregic_lt}} and summary of the fitted semiparametric regression model \code{\link[intccr]{summary.ciregic_lt}}
}
