% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IIA.r
\name{IIA}
\alias{IIA}
\title{Interval level intensity analysis}
\usage{
IIA(crosstabulation, time.points)
}
\arguments{
\item{crosstabulation}{List of crosstabulation tables generated by \code{multicrosstab} function.}

\item{time.points}{a charachter vector showing the time point of each raster layer in chronological order.}
}
\value{
The output is a list of lists. Elements of the list include: change amount, uniform intensity of change and Uniform change all in all intervals.
}
\description{
Interval level intensity analysis
}
\details{
Gets the list of crosstabulation tables, time points vector and returns a list of interval level metrics accompanied with relevant bar graphs.
}
\examples{
raster_2005 <- raster::raster(system.file("external/RASTER_2005.RST", package="intensity.analysis"))
raster_2010 <- raster::raster(system.file("external/RASTER_2010.RST", package="intensity.analysis"))
raster_2012 <- raster::raster(system.file("external/RASTER_2012.RST", package="intensity.analysis"))
raster.layers <- list(raster_2005, raster_2010, raster_2012)
time.points <- c("2005","2010","2012")
categories <- c("Water","Trees","Impervious")
crosstabulation <- multicrosstab(raster.layers, time.points, categories)
IIA.output <- IIA(crosstabulation, time.points)
}
