% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{CorrR}
\alias{CorrR}
\title{This function obtains the correlation matrix of longitudinal data}
\usage{
CorrR(y, x, beta, n, k, corre)
}
\arguments{
\item{y}{the longitudinal response.}

\item{x}{a matrix of predictors, consisting of omics and environment factors, as well as their interactions. In
the case study, the omics measurements are lipidomics data.}

\item{beta}{the coefficient vector.}

\item{n}{the sample size.}

\item{k}{a vector that contains the number of repeated measurements for each subject.}

\item{corre}{the working correlation structure that is used in estimation algorithm. interep provides three choices
for the working correlation structure: "a" as "AR-1", "i" as "independence" and "e" as "exchangeable".}
}
\value{
the correlation matrix.
}
\description{
This function obtains the correlation matrix of longitudinal data
}
\examples{
data("dat")
y=dat$y
n=dim(y)[1]
x=dat$x
data=reformat(y,x)
y=data$y
x=data$x
beta=dat$beta
corre='e'
k=rep(dat$k,n)
CorrR(y,x,beta,n,k,corre)
}
