% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msg_queue.r
\name{msg_queue}
\alias{msg_queue}
\alias{with.msg_queue}
\title{Send Text Messages Between Processes}
\usage{
msg_queue(
  name = uid(),
  assert = NULL,
  max_count = 100,
  max_nchar = 128,
  cleanup = FALSE,
  file = NULL
)

\method{with}{msg_queue}(data, expr, alt_expr = NULL, timeout_ms = Inf, ...)
}
\arguments{
\item{name}{Unique ID. Alphanumeric, starting with a letter.}

\item{assert}{Apply an additional constraint.
\itemize{
\item \code{'create'} - Error if the message queue \strong{already exists}.
\item \code{'exists'} - Error if the message queue \strong{doesn't exist}.
\item \code{NULL} - No constraint; create the message queue if it doesn't exist.
}}

\item{max_count}{The maximum number of messages that can be stored in
the queue at the same time. Attempting to send additional messages
will cause \code{send()} to block or return \code{FALSE}. Ignored if the
message queue already exists.}

\item{max_nchar}{The maximum number of characters in each message.
Attempting to send larger messages will throw an error. Ignored if
the message queue already exists.}

\item{cleanup}{Remove the message queue when the R session exits. If
\code{FALSE}, the message queue will persist until \verb{$remove()} is called
or the operating system is restarted.}

\item{file}{Use a hash of this file/directory path as the message queue
name. The file itself will not be read or modified, and does not need
to exist.}

\item{data}{A \code{msg_queue} object.}

\item{expr}{Expression to evaluate if a message is received. The message
can be accessed by \code{.} in this context. See examples.}

\item{alt_expr}{Expression to evaluate if \code{timeout_ms} is reached.}

\item{timeout_ms}{Maximum time (in milliseconds) to block the process
while waiting for the operation to succeed. Use \code{0} or \code{Inf} to
return immediately or only when successful, respectively.}

\item{...}{Not used.}
}
\value{
\code{msg_queue()} returns a \code{msg_queue} object with the following methods:
\itemize{
\item \verb{$name}
\itemize{
\item Returns the message queue's name (scalar character).
}
\item \verb{$send(msg, timeout_ms = Inf, priority = 0)}
\itemize{
\item Returns \code{TRUE} on success, or \code{FALSE} if the timeout is reached.
\item \code{msg}: The message (scalar character) to add to the message queue.
\item \code{priority}: Higher priority messages will be retrieved from the message
queue first. \code{0} = lowest priority; integers only.
}
\item \verb{$receive(timeout_ms = Inf)}
\itemize{
\item Returns the next message from the message queue, or \code{NULL} if the
timeout is reached.
}
\item \verb{$count()}
\itemize{
\item Returns the number of messages currently in the message queue.
}
\item \verb{$max_count()}
\itemize{
\item Returns the maximum number of messages the queue can hold.
}
\item \verb{$max_nchar()}
\itemize{
\item Returns the maximum number of characters per message.
}
\item \verb{$remove()}
\itemize{
\item Returns \code{TRUE} if the message queue was successfully deleted from the
operating system, or \code{FALSE} on error.\cr\cr
}
}

\code{with()} returns \code{eval(expr)} on success; \code{eval(alt_expr)} otherwise.
}
\description{
An interprocess message queue that ensures each message is delivered to only
one reader, at which time the message is removed from the queue. Ideal for
producer/consumer situations where the message defines work waiting to be
processed. The message itself can be any scalar character, for example, a
JSON string or path to an RDS file.
}
\examples{

mq <- interprocess::msg_queue()
print(mq)

mq$send(paste('my favorite number is', floor(runif(1) * 100)))
mq$count()

mq$receive()
mq$receive(timeout_ms = 0)

mq$send('The Matrix has you...')
with(mq, paste('got message:', .), 'no messages', timeout_ms = 0)
with(mq, paste('got message:', .), 'no messages', timeout_ms = 0)

mq$remove()
}
\seealso{
Other shared objects: 
\code{\link{mutex}()},
\code{\link{semaphore}()}
}
\concept{shared objects}
