% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yupana_mvr.R
\name{yupana_mvr}
\alias{yupana_mvr}
\title{Multivariate Analysis}
\usage{
yupana_mvr(
  data,
  last_factor = NULL,
  summary_by = NULL,
  groups = NULL,
  variables = NULL
)
}
\arguments{
\item{data}{Field book data.}

\item{last_factor}{The last factor in your fieldbook.}

\item{summary_by}{Variables for group the analysis.}

\item{groups}{Groups for color in PCA.}

\item{variables}{Variables to be use in the analysis.}
}
\value{
result and plots
}
\description{
Multivariate analysis for PCA and HCPC
}
\details{
Compute and plot information for multivariate analysis (PCA, HCPC and
correlation).
}
\examples{

\dontrun{

library(inti)
library(gsheet)

url <- paste0("https://docs.google.com/spreadsheets/d/"
              , "15r7ZwcZZHbEgltlF6gSFvCTFA-CFzVBWwg3mFlRyKPs/edit#gid=172957346")
# browseURL(url)

fb <- gsheet2tbl(url)

mv <- yupana_mvr(data = fb
                    , last_factor = "bloque"
                    , summary_by = c("geno", "treat")
                    , groups = NULL
                    )

FactoMineR::plot.PCA(mv$pca, choix = "ind", habillage =  mv$param$groups)

}

}
