% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tarpuy_design.R
\name{tarpuy_design}
\alias{tarpuy_design}
\title{Fieldbook experimental designs}
\usage{
tarpuy_design(
  data,
  nfactors = 1,
  type = "crd",
  rep = 2,
  serie = 2,
  seed = 0,
  barcode = NA
)
}
\arguments{
\item{data}{Experimental design data frame with the factors and level. See
examples.}

\item{nfactors}{Number of factor in the experiment(default = 1). See
details.}

\item{type}{Type of experimental arrange  (default = "crd"). See details.}

\item{rep}{Number of replications in the experiment (default = 3).}

\item{serie}{Digits in the plot id (default = 2).}

\item{seed}{Replicability of draw results (default = 0) always random. See
details.}

\item{barcode}{Barcode prefix for data collection.}
}
\value{
A list with the fieldbook design
}
\description{
Function to deploy experimental designs
}
\details{
The function allows to include the arguments in the sheet that have
  the information of the design. You should include 2 columns in the sheet:
  \code{{arguments}} and \code{{values}}. See examples. The information will
  be extracted automatically and deploy the design. \code{nfactors} = 1:
  crd, rcbd, lsd, lattice. \code{nfactors} = 2 (factorial): split-crd,
  split-rcbd split-lsd \code{nfactors} >= 2 (factorial): crd, rcbd, lsd.
}
\examples{

\dontrun{

library(inti)
library(gsheet)

url <- paste0("https://docs.google.com/spreadsheets/d/"
              , "183upHd4wriZz2UnInoo5Ate5YFdk7cZlhE0sMQ2x5iw/edit#gid=532773890")
# browseURL(url)

fb <- gsheet2tbl(url) 

tarpuy_design(data = fb) 

}
}
