% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iCoxph.R
\name{iCoxph.control}
\alias{iCoxph.control}
\title{Auxiliary for Controlling iCoxph Fitting}
\usage{
iCoxph.control(tol_beta = 1e-6, tol_pi = 1e-8, cm_gradtol = 1e-6,
               cm_stepmax = 1e2, cm_steptol = 1e-6, cm_max_iter = 1e2,
               ecm_max_iter = 2e2, ...)
}
\arguments{
\item{tol_beta}{A positive value specifying the tolerance that concludes the
convergence of the covariate coefficient estimates. The tolerance is
compared with the relative change between the estimates from two
consecutive iterations that is measured by ratio of the L2-norm of their
difference to the sum of their L2-norm.  The default value is
\code{1e-6}.}

\item{tol_pi}{A positive value specifying the tolerance that concludes the
convergence of the probability estimates of uncertain records being
true.  The tolerance is compared with the relative change between the
estimates from two consecutive iterations measured by ratio of L2-norm
of their difference to the L2-norm of their sum.  The default value is
\code{1e-8}.}

\item{cm_gradtol}{A positive scalar giving the tolerance at which the scaled
gradient is considered close enough to zero to terminate CM steps.  The
default value is \code{1e-6}.}

\item{cm_stepmax}{A positive scalar that gives the maximum allowable scaled
step length in CM steps.  The default value is \code{1e2}.}

\item{cm_steptol}{A positive scalar providing the minimum allowable relative
step length in CM step.  The default value is \code{1e-6}.}

\item{cm_max_iter}{A positive integer specifying the maximum number of
iterations to be performed before each CM step is terminated. The
default value is \code{1e2}.}

\item{ecm_max_iter}{A positive integer specifying the maximum number of
iterations to be performed before the ECM algorithm is terminated. The
default value is \code{2e2}.}

\item{...}{Other arguments for future usage.  A warning will be thrown if
any invalid argument is specified.}
}
\value{
A list of class \code{intsurv-iCoxph.control} containing all
    specified control parameters.
}
\description{
Auxiliary function for \code{\link{iCoxph}} that enable users to specify the
control parameters of the model estimation procedure.  Internally, the
arguments \code{cm_gradtol}, \code{cm_stepmax}, \code{cm_steptol}, and
\code{cm_max_iter} are passed to function \code{\link[stats]{nlm}} as
\code{gradtol}, \code{stepmax}, \code{steptol}, and \code{iterlim},
respectively.
}
\examples{
## See examples of function 'iCoxph'.

}
\seealso{
\code{\link{iCoxph}} for fitting integrative Cox model.
}
