% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_methods_residuals.R
\name{residuals.pk}
\alias{residuals.pk}
\title{Get residuals}
\usage{
\method{residuals}{pk}(
  object,
  newdata = NULL,
  model = NULL,
  method = NULL,
  exclude = TRUE,
  use_scale_conc = FALSE,
  suppress.messages = NULL,
  ...
)
}
\arguments{
\item{object}{A [pk] object}

\item{newdata}{Optional: A `data.frame` with new data for which to make
predictions and compute residuals. If NULL (the default), then residuals
will be computed for the data in `object$data`. `newdata` is required to
contain at least the following variables: `Time`, `Time.Units`, `Dose`,
`Route`, `Media`, `Conc`, `Detect`.}

\item{model}{Optional: Specify one or more of the fitted models for which to
make predictions and calculate residuals. If NULL (the default), residuals
will be returned for all of the models in `object$stat_model`.}

\item{method}{Optional: Specify one or more of the [optimx::optimx()] methods
for which to make predictions and calculate residuals. If NULL (the
default), residuals will be returned for all of the models in
`object$optimx_settings$method`.}

\item{exclude}{Logical: `TRUE` to return `NA_real_` for any observations in
the data marked for exclusion (if there is a variable `exclude` in the
data, an observation is marked for exclusion when `exclude %in% TRUE`).
`FALSE` to return the residual for each observation, regardless of
exclusion. Default `TRUE`.}

\item{use_scale_conc}{Possible values: `TRUE`, `FALSE`, or a named list with
elements `dose_norm` and `log10_trans` which themselves should be either
`TRUE` or `FALSE`. If `use_scale_conc = TRUE`, then the concentration
scaling/transformations in `object` will be applied to both predicted and
observed concentrations before the residuals are computed (i.e., the
residuals will be computed on the same scale as the model was originally
fitted). If `use_scale_conc = FALSE` (the default for this function), then
no concentration scaling or transformation will be applied before the
residuals are computed (i.e., the residuals will be computed on natural
scale concentration data). If `use_scale_conc = list(dose_norm = ...,
log10_trans = ...)`, then the specified dose normalization and/or
log10-transformation will be applied.}

\item{suppress.messages}{Logical: whether to suppress message printing. If
NULL (default), uses the setting in
`object$settings_preprocess$suppress.messages`}

\item{...}{Additional arguments not currently used.}
}
\value{
A data.frame with the final column being calculated residuals.
  There is one row per each [optimx::optimx()] methods (specified in
  [settings_optimx()]), and `data_group`.  The final column
  contains the residuals (observed - predicted) of the model fitted by the
  corresponding method.  If `use_scale_conc %in% FALSE`, these residuals are
  in the same units as `object$data$Conc.Units`. If `use_scale_conc %in% TRUE`,
  the residuals are in the same units as `object$data$Conc_trans.Units`. If
  `use_scale_conc` was a named list, then the residuals are in units of
  `object$data$Conc.Units` transformed as specified in `use_scale_conc`.
}
\description{
Extract residuals from a fitted `pk` object.
}
\details{
Residuals are `obs - pred` in general, where `obs` is the observed
concentration value and `pred` is the predicted concentration value.

For non-detect observations, residual is zero if `pred` is also below the
LOQ. Otherwise, the residual is the difference between the LOQ and `pred`.
}
\seealso{
Other methods for fitted pk objects: 
\code{\link{AAFE.pk}()},
\code{\link{AFE.pk}()},
\code{\link{AIC.pk}()},
\code{\link{BIC.pk}()},
\code{\link{coef.pk}()},
\code{\link{coef_sd.pk}()},
\code{\link{eval_tkstats.pk}()},
\code{\link{get_fit.pk}()},
\code{\link{get_hessian.pk}()},
\code{\link{get_tkstats.pk}()},
\code{\link{logLik.pk}()},
\code{\link{predict.pk}()},
\code{\link{rmse.pk}()},
\code{\link{rsq.pk}()}
}
\author{
Caroline Ring, Gilberto Padilla Mercado
}
\concept{methods for fitted pk objects}
