% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ytd.R
\encoding{UTF-8}
\name{ytd}
\alias{ytd}
\title{Calcul de la performance ytd : year-to-date.}
\usage{
ytd(data, date, a = 0, x, unite = 1, decimal = 0, cumul = FALSE)
}
\arguments{
\item{data}{Un objet de type data.frame contenant au minimum la serie numerique et un vecteur de type date.}

\item{date}{La date jusqu’à laquelle on vq sommer les valeur de la série depuis le début de l'année.}

\item{a}{Une valeur de type entier qui permet de décaler l'année par rapport à la date introduite si la série s'etend sur plus d'une année. Sa valeur par defaut est \code{0}.}

\item{x}{Un vecteur de type numeric contenant les observations du phénomène à etudier.}

\item{unite}{Un valeur de type numeric, definissant l'ordre d'echelle d'affisage du resultat de la fonction. Sa valeur par defaut est \code{1}.}

\item{decimal}{Un objet de type numeric permettant de préciser le nombre d'entier à afficher après la virgule. Sa valeur par defaut est \code{0}.}

\item{cumul}{Un objet de type logic qui permet d'indiquer si le vecteur \code{x} contient des valeurs cumulées. Sa valeur par defaut est \code{FALSE}.}
}
\value{
Un vecteur de longieur 1.
}
\description{
Cette fonction permet de calculer la somme des valeurs d'une série dans l'année, partant du 1er jour de l'année jusqu'à une date de la même année introduit par l'utilisateur.
}
\examples{
x <- rnorm(102, mean = 50, sd = 6.3)
date <- seq.Date(as.Date("2022-12-01"), by = "day", length.out = 102)
df <- data.frame(date, x)
ytd(df, date = "2023-01-08", x = "x")

}
