% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datafiles.R
\docType{data}
\name{bombhits}
\alias{bombhits}
\title{Number of bomb hits in London during World War II}
\format{
A data frame with two columns and six rows:
\describe{
  \item{numberhit}{The number of  bomb hits during World War II 
  in each of the 576 areas in London.}
  \item{freq}{Frequency of the number of hits}
}
}
\source{
\insertCite{bombhits;textual}{ipsRdbs}.
}
\usage{
bombhits
}
\description{
Number of bomb hits in London during World War II
}
\examples{
 summary(bombhits)
 # Create a vector of data 
 x <- c(rep(0, 229), rep(1, 211), rep(2, 93), rep(3, 35), rep(4, 7), 5)
 y <- c(229, 211, 93, 35, 7, 1) # Frequencies 
 rel_freq <- y/576
 xbar <- mean(x)
 pois_prob <- dpois(x=0:5, lambda=xbar)
 fit_freq <- pois_prob * 576
  #Check 
  cbind(x=0:5, obs_freq=y, rel_freq =round(rel_freq, 4),  
  Poisson_prob=round(pois_prob, 4), fit_freq=round(fit_freq, 1))
  obs_freq <- y
  xuniques <- 0:5
  a <- data.frame(xuniques=0:5, obs_freq =y, fit_freq=fit_freq)
  barplot(rbind(obs_freq, fit_freq), 
  args.legend = list(x = "topright"), 
  xlab="No of bomb hits",  
  names.arg = xuniques,  beside=TRUE, 
  col=c("darkblue","red"), 
  legend =c("Observed", "Fitted"), 
  main="Observed and Poisson distribution fitted frequencies 
  for the number of bomb hits in London")
}
\keyword{datasets}
