% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{remove_from_extract}
\alias{remove_from_extract}
\alias{remove_from_extract.usa_extract}
\alias{remove_from_extract.cps_extract}
\title{Remove values from an IPUMS USA or CPS extract}
\usage{
remove_from_extract(extract, ...)

\method{remove_from_extract}{usa_extract}(extract, samples = NULL, variables = NULL, ...)

\method{remove_from_extract}{cps_extract}(extract, samples = NULL, variables = NULL, ...)
}
\arguments{
\item{extract}{An \code{\link[=ipums_extract-class]{ipums_extract}} object.}

\item{...}{Further arguments passed to methods.}

\item{samples}{Character vector of samples to remove from the extract,
if any.}

\item{variables}{Character vector of variables to remove from the extract,
if any.}
}
\value{
A modified IPUMS USA or CPS extract object
}
\description{
Remove existing values from fields of an IPUMS USA or CPS extract object. All
fields are optional, and if omitted, will remain unchanged.

To add new values to an extract, see \code{\link[=add_to_extract]{add_to_extract()}}.

For an overview of ipumsr microdata API functionality, see
\code{vignette("ipums-api", package = "ipumsr")}.
}
\section{Note}{

If the supplied extract definition comes from
a previously submitted extract, this function will reset the definition to an
unsubmitted state.
}

\examples{
usa_extract <- define_extract_usa(
  description = "USA example",
  samples = c("us2013a", "us2014a"),
  variables = "YEAR"
)

revised_usa_extract <- remove_from_extract(
  usa_extract,
  samples = "us2014a"
)

revised_usa_extract


cps_extract <- define_extract_cps(
  description = "CPS example",
  samples = c("cps2019_03s", "cps2020_03s"),
  variables = "YEAR"
)

revised_cps_extract <- remove_from_extract(
  cps_extract,
  samples = "cps2020_03s"
)

revised_cps_extract
}
\seealso{
Other ipums_api: 
\code{\link{add_to_extract}()},
\code{\link{define_extract_cps}()},
\code{\link{define_extract_from_json}()},
\code{\link{define_extract_usa}()},
\code{\link{download_extract}()},
\code{\link{extract_list_to_tbl}()},
\code{\link{extract_tbl_to_list}()},
\code{\link{get_extract_info}()},
\code{\link{get_last_extract_info}()},
\code{\link{get_recent_extracts_info}},
\code{\link{ipums_data_collections}()},
\code{\link{is_extract_ready}()},
\code{\link{save_extract_as_json}()},
\code{\link{set_ipums_api_key}()},
\code{\link{submit_extract}()},
\code{\link{wait_for_extract}()}
}
\concept{ipums_api}
