% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_process_extract.R
\name{download_supplemental_data}
\alias{download_supplemental_data}
\title{Download IPUMS supplemental data files}
\usage{
download_supplemental_data(
  collection,
  path,
  download_dir = getwd(),
  overwrite = FALSE,
  progress = TRUE,
  api_key = Sys.getenv("IPUMS_API_KEY")
)
}
\arguments{
\item{collection}{Code for the IPUMS collection represented by this
extract request. Currently, only \code{"nhgis"} is supported.}

\item{path}{Path to the supplemental data file to download. See examples.}

\item{download_dir}{Path to the directory where the files should be written.
Defaults to current working directory.}

\item{overwrite}{If \code{TRUE}, overwrite files with the same name that
already exist in \code{download_dir}. Defaults to \code{FALSE}.}

\item{progress}{If \code{TRUE}, output progress bar showing the status of the
download request. Defaults to \code{TRUE}.}

\item{api_key}{API key associated with your user account. Defaults to the
value of the \code{IPUMS_API_KEY} environment variable. See
\code{\link[=set_ipums_api_key]{set_ipums_api_key()}}.}
}
\value{
The path to the downloaded supplemental data file
}
\description{
Some IPUMS collections provide supplemental data files that are available
outside of the IPUMS extract system. Use this function to download these
files.

Currently, only IPUMS NHGIS files are supported.

In general, files found on an IPUMS project website that include
\code{secure-assets} in their URL are available as supplemental data. See the
\href{https://developer.ipums.org/docs/v2/apiprogram/apis/nhgis/}{IPUMS developer documentation}
for more information on available endpoints.
}
\examples{
\dontrun{
# Download a state-level tract to county crosswalk from NHGIS
file <- download_supplemental_data(
  "nhgis",
  "crosswalks/nhgis_tr1990_co2010_state/nhgis_tr1990_co2010_10.zip"
)

read_nhgis(file)

# Download 1980 Minnesota block boundary file
file <- download_supplemental_data(
  "nhgis",
  "blocks-1980/MN_block_1980.zip"
)

read_ipums_sf(file)
}
}
