% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lbl_helpers.R
\name{lbl_na_if}
\alias{lbl_na_if}
\title{Convert labelled data values to NA}
\usage{
lbl_na_if(x, .predicate)
}
\arguments{
\item{x}{A \code{\link[haven:labelled]{labelled}} vector}

\item{.predicate}{A function taking \code{.val} and \code{.lbl} arguments that
returns \code{TRUE} for all values that should be converted to \code{NA}.

Can be provided as an anonymous function or formula. See Details section.}
}
\value{
A \code{\link[haven:labelled]{labelled}} vector
}
\description{
Convert data values in a \code{\link[haven:labelled]{labelled}} vector
to \code{NA} based on the value labels associated with that vector. Ignores
values that do not have a label.
}
\details{
Several \verb{lbl_*()} functions include arguments that can be passed a function
of \code{.val} and/or \code{.lbl}. These refer to the existing values and
labels in the input vector, respectively.

Use \code{.val} to refer to the \emph{values} in the vector's value labels.
Use \code{.lbl} to refer to the \emph{label names} in the vector's value labels.

Note that not all \verb{lbl_*()} functions support both of these arguments.
}
\examples{
x <- haven::labelled(
  c(10, 10, 11, 20, 30, 99, 30, 10),
  c(Yes = 10, `Yes - Logically Assigned` = 11, No = 20, Maybe = 30, NIU = 99)
)

# Convert labelled values greater than 90 to `NA`
lbl_na_if(x, function(.val, .lbl) .val >= 90)

# Can use purrr-style notation
lbl_na_if(x, ~ .lbl \%in\% c("Maybe"))

# Or refer to named function
na_function <- function(.val, .lbl) .val >= 90
lbl_na_if(x, na_function)
}
\seealso{
Other lbl_helpers: 
\code{\link{lbl}()},
\code{\link{lbl_add}()},
\code{\link{lbl_clean}()},
\code{\link{lbl_define}()},
\code{\link{lbl_relabel}()},
\code{\link{zap_ipums_attributes}()}
}
\concept{lbl_helpers}
