% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AIModels.R
\name{get_linearBayes}
\alias{get_linearBayes}
\title{get the computation of parameters issued from the training of a Bayesian linear regression}
\usage{
get_linearBayes(X = NULL, Y = NULL, params = NA)
}
\arguments{
\item{X}{is a matrix of features (e.g. fingerprints and/or physical descriptors) issued from a training set.}

\item{Y}{is a one-dimensional vector, or a matrix, of observables (e.g. targeted chemical properties) issued from a training
set.}

\item{params}{corresponds to the initialization of the parameters (see \code{\link{get_Model_params}} for a parameters
list) if known \emph{a priori} (NA by default).}
}
\value{
the latest w0, V0_inv, a0 and b0 parameters after training over the data X and Y.
}
\description{
Get the computation of parameters issued from the training of a Bayesian linear regression.
See the iqspr package paper for details concerning the definition of the cited parameters.
}
\examples{
\dontrun{linearBayes_model <- get_linearBayes(X = X[training,], Y = Y[training,],
params = c(list(w0),list(V0_inv),list(a0),list(b0)))}
}
