% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling_frequency.R
\name{sampling_frequency}
\alias{sampling_frequency}
\title{Parameter Frequency and Density Plot}
\usage{
sampling_frequency(
  configurations,
  parameters,
  param_names = NULL,
  n = NULL,
  filename = NULL
)
}
\arguments{
\item{configurations}{(\code{data.frame()})\cr Configurations in \code{irace} format. Example: \code{iraceResults$allConfigurations}.}

\item{parameters}{(\code{list()})\cr Parameters object in \code{irace} format. If this argument
is missing, the first parameter is taken as the \code{iraceResults} data
generated when loading the \code{.Rdata} file created by \code{irace} and
\code{configurations=iraceResults$allConfigurations} and \code{parameters = iraceResults$parameters}.}

\item{param_names}{(\code{character()}) Parameters to be included in the plot. Example:
\code{c("algorithm","alpha","rho","q0","rasrank")}.}

\item{n}{Numeric, for scenarios with large parameter sets, it selects a subset
of 9 parameters. For example, \code{n=1} selects the first 9 (1 to 9) parameters, n=2 selects
the next 9 (10 to 18) parameters and so on.}

\item{filename}{(\code{character(1)}) File name to save the plot, for example \code{"~/path/example/filename.png"}.}
}
\value{
Frequency and/or density plot
}
\description{
Frequency or density plot that depicts the sampling performed by irace
across the iterations of the configuration process.  For categorical
parameters a frequency plot is created, while for numerical parameters a
histogram and density plots are created. The plots are shown in groups of
maximum 9, the parameters included in the plot can be specified by setting
the param_names argument.
}
\note{
If there are more than 9 parameters, a pdf file extension is
recommended as it allows to create a multi-page document. Otherwise, you
can use the \code{n} argument of the function to generate the plot of a subset
of the parameters.
}
\examples{
# Either use iraceResults
iraceResults <- read_logfile(system.file(package="iraceplot", "exdata",
                                         "guide-example.Rdata", mustWork = TRUE))
sampling_frequency(iraceResults)
\donttest{ 
sampling_frequency(iraceResults, n = 2)
sampling_frequency(iraceResults, param_names = c("alpha"))
sampling_frequency(iraceResults, param_names = c("algorithm", "alpha", "rho", "q0", "rasrank"))
}
# Or explicitly specify the configurations and parameters.
sampling_frequency(iraceResults$allConfigurations, iraceResults$parameters)
\donttest{ 
sampling_frequency(iraceResults$allConfigurations, iraceResults$parameters, n = 2)
sampling_frequency(iraceResults$allConfigurations, iraceResults$parameters, 
                    param_names = c("alpha"))
sampling_frequency(iraceResults$allConfigurations, iraceResults$parameters, 
                    param_names = c("algorithm", "alpha", "rho", "q0", "rasrank"))
}
}
