% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{model_params}
\alias{model_params}
\title{Estimate model parameters}
\usage{
model_params(
  DT,
  returns = NULL,
  id = "id",
  year = "yr",
  xmidS = NULL,
  xmidA = NULL,
  scalS = NULL,
  scalA = NULL
)
}
\arguments{
\item{DT}{data.table of NDVI time series. Also optionally starting estimates. See Details.}

\item{returns}{either 'models' or 'columns'. 'models' will return a data.table of model outcomes by id and year. 'columns' will append model estimate parameters to the input DT.}

\item{id}{id column. default is 'id'. See details.}

\item{year}{year column name. default is 'yr'.}

\item{xmidS}{starting estimates. see Details. - "spring inflection point"}

\item{xmidA}{starting estimates. see Details. - "fall inflection point"}

\item{scalS}{starting estimates. see Details. - "scale parameter for spring green-up portion of the NDVI curve"}

\item{scalA}{starting estimates. see Details. - "scale parameter for fall dry-down portion of the NDVI curve"}
}
\value{
data.table of model estimated parameters for double logistic model. If any rows are NULL, \code{nls} could not fit a model given starting parameters to the data provided.
}
\description{
Model estimated parameters for fitting double logistic curve.
}
\details{
Arguments \code{xmidS}, \code{xmidA}, \code{scalS}, \code{scalA} allow users to provide either group level or global starting estimates to be used for all models.

Either: a character indicating the column name which stores a group level starting parameter (possibly created by \code{\link{model_start}} OR a numeric value used as a global value for all models. See \code{\link{nls}} for more details on starting parameters.

Default value for the year column is 'yr'. If you only have one year of data, set to NULL.

The id argument is used to split between sampling units. This may be a point id, polygon id, pixel id, etc. depending on your analysis. This should match the id provided to filtering functions.

Formula and arguments \code{xmidS}, \code{xmidA}, \code{scalS}, \code{scalA} following this from Bischoff et al. (2012).

\deqn{fitted = \frac{1}{1 + \exp{\frac{xmidS - t}{scalS}}} - \frac{1}{1 + \exp{\frac{xmidA - t}{scalA}}}}
}
\examples{
# Load data.table
library(data.table)

# Read in example data
ndvi <- fread(system.file("extdata", "sampled-ndvi-MODIS-MOD13Q1.csv", package = "irg"))

# Filter and scale NDVI time series
filter_ndvi(ndvi)
scale_doy(ndvi)
scale_ndvi(ndvi)

# Guess starting parameters for xmidS and xmidA
model_start(ndvi)

# Double logistic model parameters
#   given global starting parameters for scalS, scalA
#   and output of model_start for xmidS, xmidA
mods <- model_params(
  ndvi,
  returns = 'models',
  xmidS = 'xmidS_start',
  xmidA = 'xmidA_start',
  scalS = 0.05,
  scalA = 0.01
)
}
\references{
\url{https://www.journals.uchicago.edu/doi/abs/10.1086/667590}
}
\seealso{
Other model: 
\code{\link{model_ndvi}()},
\code{\link{model_start}()}
}
\concept{model}
