% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item-class-methods.R,
%   R/itempool-class-methods.R
\name{as.data.frame.Item}
\alias{as.data.frame.Item}
\alias{as.data.frame.GRM}
\alias{as.data.frame.PCM}
\alias{as.data.frame.GPCM}
\alias{as.data.frame.GPCM2}
\alias{as.data.frame.M2PL}
\alias{as.data.frame.M3PL}
\alias{as.data.frame.Itempool}
\alias{as.data.frame.Testlet}
\title{Convert an \code{\link{Item-class}} object into a \code{data.frame}.}
\usage{
\method{as.data.frame}{Item}(x, row.names = NULL, optional = FALSE, ..., include_se = TRUE)

\method{as.data.frame}{GRM}(x, row.names = NULL, optional = FALSE, ..., include_se = TRUE)

\method{as.data.frame}{PCM}(x, row.names = NULL, optional = FALSE, ..., include_se = TRUE)

\method{as.data.frame}{GPCM}(x, row.names = NULL, optional = FALSE, ..., include_se = TRUE)

\method{as.data.frame}{GPCM2}(x, row.names = NULL, optional = FALSE, ..., include_se = TRUE)

\method{as.data.frame}{M2PL}(x, row.names = NULL, optional = FALSE, ..., include_se = TRUE)

\method{as.data.frame}{M3PL}(x, row.names = NULL, optional = FALSE, ..., include_se = TRUE)

\method{as.data.frame}{Itempool}(x, row.names = NULL, optional = FALSE, ..., include_se = TRUE)

\method{as.data.frame}{Testlet}(x, row.names = NULL, optional = FALSE, ..., include_se = TRUE)
}
\arguments{
\item{x}{An \code{\link{Testlet-class}} object}

\item{row.names}{\code{NULL} or a character vector giving the row name for
the data frame. Missing values are not allowed.}

\item{optional}{logical. If \code{TRUE}, setting row names and converting
column names}

\item{...}{additional arguments}

\item{include_se}{If \code{TRUE}, and items have \code{se_parameters},
those will be included in the data frame.}
}
\value{
A data frame representation of the item.

A data frame representation of the GRM item.

A data frame representation of the PCM item.

A data frame representation of the GPCM item.

A data frame representation of the GPCM2 item.

A data frame representation of the M2PL item.

A data frame representation of the M3PL item.

A data frame of items within each row. If all items cannot be
  coerced to a \code{data.frame}, an list of items will be returned and a
  warning will be raised.

A data frame representation of the item.
}
\description{
This function converts \code{\link{Item-class}} objects to a
  \code{data.frame} object.

This function converts \code{\link{Itempool-class}} objects to a
  \code{data.frame} object.

This function converts \code{\link{Testlet-class}} objects to a
  \code{data.frame} object. If testlet has an ID, an additional column
  will be created for the testlet ID.
}
\examples{
item1 <- generate_item()
as.data.frame(item1)

item2 <- generate_item(model = "Rasch", item_id = "i1",
                       misc = list(type = "MC", op = TRUE, c("i1", "i2")))
as.data.frame(item2)

item3 <- generate_item(model = "GRM")
as.data.frame(item3)

item1 <- generate_item(model = "GRM", item_id = "i1")
as.data.frame(item1)
item1 <- generate_item(model = "PCM", item_id = "i1")
as.data.frame(item1)
item1 <- generate_item(model = "GPCM", item_id = "i1")
as.data.frame(item1)
item1 <- generate_item(model = "GPCM2", item_id = "i1")
as.data.frame(item1)
item1 <- generate_item(model = "M2PL", item_id = "i1")
as.data.frame(item1)
item1 <- generate_item(model = "M3PL", item_id = "i1")
as.data.frame(item1)
ip1 <- generate_ip()
as.data.frame(ip1)

ip2 <- generate_ip(n = 10, model = "GRM",
                   content = sample(c("G", "A"), 10, TRUE),
                   item_id = paste0("grm-i-", 1:10))
as.data.frame(ip2)

t1 <- generate_testlet(n = 3, item_id_preamble = "t1")
t2 <- generate_testlet(n = 2, item_id_preamble = "t2")
ip3 <- c(ip1, t1, t2)
as.data.frame(ip3)

ip4 <- c(ip2, ip3)
as.data.frame(ip4)


item1 <- item(a = 1.12, b = -2.1, c = 0.28)
item2 <- item(a = 2, b = 3.2, c = 0.21)

ip1 <- c(item1, item2)
as.data.frame(ip1)
testlet1 <- generate_testlet()
as.data.frame(testlet1)
testlet2 <- generate_testlet(testlet_id = "T1")
as.data.frame(testlet2)
}
\author{
Emre Gonulates

Emre Gonulates

Emre Gonulates

Emre Gonulates

Emre Gonulates

Emre Gonulates

Emre Gonulates

Emre Gonulates

Emre Gonulates
}
