% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_itempool.R
\name{plot.Itempool}
\alias{plot.Itempool}
\title{Plot Item Characteristic Curves or Test Characteristic Curve of an
\code{Itempool} object}
\usage{
\method{plot}{Itempool}(
  x,
  theta_range = c(-4, 4),
  type = "icc",
  tcc_prop_corr = FALSE,
  focus_item = NULL,
  title = "",
  suppress_plot = FALSE,
  legend_title = NULL,
  base_r_graph = FALSE,
  y_lim = NULL,
  ...
)
}
\arguments{
\item{x}{An \code{\link{Itempool-class}} object.}

\item{theta_range}{Either a numeric vector of length two setting the
boundaries of x-axis, e.g. \code{c(-4, 4)}, or, a numeric vector that is
includes the theta values  that will be plotted, e.g.
\code{seq(-3, 3, by = 0.1)}.}

\item{type}{The type of the graph. The default value is \code{"icc"}.
Available options are:
\describe{
  \item{\strong{\code{"icc"}}}{Plot item characteristic curve of each item}
  \item{\strong{\code{"tcc"}}}{Plot test characteristic curve}
  \item{\strong{\code{"hist"}}}{Plot histograms of item parameters}
  \item{\strong{\code{"pars"}}}{Plot dot plot of item parameters}
}}

\item{tcc_prop_corr}{If \code{TRUE}, test characteristic curve will be
show the proportion correct of the test (i.e. the range of y-axis
will be 0-1 instead of 0 to the number of items).}

\item{focus_item}{A character string of the 'item_id' of the item to be
focused. If \code{type = "pars"}, this item will be shown with a
red dot to distinguish it from others.}

\item{title}{Title of the plot. Set \code{title = NULL} to suppress the plot
title. The default is \code{""}.
If \code{type = "tcc"} and \code{title = ""}, title will be 'Test
Characteristic Curve'. If \code{type = "icc"} and \code{title = ""}, title
will be 'Item Characteristic Curve'. If \code{type = "hist"} or
\code{type = "pars"} and \code{title = ""}, title will be
'Parameter Values'.}

\item{suppress_plot}{If \code{FALSE} the function will print the plot. If
\code{TRUE}, function will return the plot object. Default value is
\code{FALSE}.}

\item{legend_title}{The title of the plot's legend.}

\item{base_r_graph}{If \code{TRUE} function will plot graphs using base R
graphics. If \code{FALSE} the function will check whether 'ggplot2' package
is installed. If it is installed, it will use 'ggplot2' package for the
plot. The default value is \code{FALSE}.}

\item{y_lim}{A numeric vector of length two representing the lower and
upper bound of y-axis.}

\item{...}{Additional arguments that will be passed to \code{geom_line}}
}
\value{
Depending on the value of \code{suppress_plot} function either prints
the item characteristic curve or returns the plot object.
}
\description{
\code{plot.Itempool} plots the item characteristic curves (item response
curves) or test characteristic curve of an \code{\link{Itempool-class}}
object.
}
\examples{
ip <- generate_ip(n = sample(10:15,1))
plot(ip)

# Additional arguments will passed to geom_line
plot(ip, size = .25, alpha = 0.3)

# Set the boundaries of the graph
plot(ip, theta_range = c(-2, 2))
# alternatively provide theta values
plot(ip, theta_range = seq(-6, 6, by = 0.25))


# Test Characteristic Curve
plot(ip, type = "tcc")

# Proportion correct for test characteristic curve
plot(ip, type = "tcc", tcc_prop_corr = TRUE)

# Plot histogram of item parameters
plot(ip, type = "hist")


\dontrun{
# Item parameter summary
ip <- generate_ip(n = 200)
plot(ip, type = "pars")
plot(ip, type = "pars", dotsize = .75)
plot(ip, type = "pars", focus_item = "Item_22")
# Use base R graphics
plot(ip, type = "pars", base_r_graph = TRUE)

# # Remove the legend altogether
# plot(ip, suppress_plot = TRUE) + ggplot2::theme(legend.position="none")
# # Change the labels:
# plot(ip, suppress_plot = TRUE) +
#   ylab("Probability") + xlab("Ability Score")
}

}
\author{
Emre Gonulates
}
