% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covirt.R
\name{covirt}
\alias{covirt}
\title{Asymptotic variance-covariance matrices of item parameter estimates}
\usage{
covirt(
  x,
  D = 1,
  nstd = 1000,
  pcm.loc = NULL,
  norm.prior = c(0, 1),
  nquad = 41,
  weights = NULL
)
}
\arguments{
\item{x}{A data frame containing the item metadata (e.g., item parameters, number of categories, models ...).
See \code{\link{irtfit}}, \code{\link{info}}, or \code{\link{simdat}} for more details about the item metadata.
This data frame can be easily obtained using the function \code{\link{shape_df}}.}

\item{D}{A scaling factor in IRT models to make the logistic function as close as possible to the normal ogive function (if set to 1.7).
Default is 1.}

\item{nstd}{An integer value or a vector of integer values indicating a sample size. When a vector is specified, length of the vector must be
the same as the number of test items in the argument \code{x}. Default is 1,000. See below for details.}

\item{pcm.loc}{A vector of integer values indicating the locations of partial credit model (PCM) items. For the PCM items,
the variance-covariance matrices are computed only for the item category difficulty parameters. Default is NULL. See below for details.}

\item{norm.prior}{A numeric vector of two components specifying a mean and standard deviation of the normal prior distribution.
These two parameters are used to obtain the gaussian quadrature points and the corresponding weights from the normal distribution.
Default is c(0,1).}

\item{nquad}{An integer value specifying the number of gaussian quadrature points from the normal prior distribution. Default is 41.}

\item{weights}{A two-column matrix or data frame containing the theta values (in the first column) and the weights (in the second column)
for the prior distribution. The weights and theta values can be easily obtained using the function \code{\link{gen.weight}}.
If NULL, default values are used for the prior distribution (see the arguments of \code{norm.prior} and \code{nquad}). Default is NULL.}
}
\value{
A list of two internal objects. The first internal object contains a list of the variance-covariance matrices of item parameter estimates.
The second internal object contains a list of the standard errors of item parameter estimates.
}
\description{
This function calculates the analytical asymptotic variance-covariance matrices (e.g., Li & Lissitz, 2004; Thissen & Wainer, 1982)
of item parameter estimates for dichotomous and polytomous IRT Models without examinee's responses to test items,
given a set of item parameter estimates and sample size. The square roots of variance terms in the matrices can be used as the asymptotic
standard errors of maximum likelihood item parameter estimates.
}
\details{
The standard errors obtained from the analytical approach are likely to represent lower bounds for the actual standard errors (Thissen & Wainer, 1982).
Therefore, they may be useful for assessing the degree of precision of a set of item parameter estimates when the corresponding standard errors of
the estimates are not presented in literature or research reports.

Sometimes item parameters need to be estimated using different sample size. If the item parameters in the argument \code{x} were
calibrated with different number of examinees, a vector of different sample sizes should be specified in the argument \code{nstd}. Suppose
that you want to compute the variance-covariance matrices of five IRT 3PLM items and the five items were calibrated with 500, 600, 1,000, 2,000,
and 700 examinees, respectively. Then, \code{nstd = c(500, 600, 1000, 2000, 700)} must be specified.

Because you can specify only "GPCM" for both the partial credit model (PCM) or the generalized partial credit model (GPCM) in the item metadata,
you must indicate which items are the PCM items through the argument \code{pcm.loc}. This is because the item category difficulty parameters are estimated
from the PCM, meaning that the variance-covariance of item parameter estimates must be computed for the item category difficulty parameters. Suppose
that you want to compute the variance-covariance matrices of five polytomous items and the last two items were calibrated with the PCM. Then,
\code{pcm.loc = c(4, 5)} must be specified.
}
\examples{
## the use of a "-prm.txt" file obtained sfrom a flexMIRT
flex_prm <- system.file("extdata", "flexmirt_sample-prm.txt", package = "irtQ")

# select the first two dichotomous items and last polytomous item
x <- bring.flexmirt(file=flex_prm, "par")$Group1$full_df[c(1:2, 55), ]

# compute the var-covariance matrices with sample size of 2,000
covirt(x, D=1, nstd=2000, norm.prior=c(0, 1), nquad=41)

}
\references{
Li, Y. & Lissitz, R. (2004). Applications of the analytically derived asymptotic standard errors of item response theory
item parameter estimates. \emph{Journal of educational measurement, 41}(2), 85-117.

Thissen, D. & Wainer, H. (1982). Weighted likelihood estimation of ability in item response theory.
\emph{Psychometrika, 54}(3), 427-450.
}
\seealso{
\code{\link{irtfit}}, \code{\link{info}}, \code{\link{simdat}}, \code{\link{shape_df}}, \code{\link{gen.weight}}
}
\author{
Hwanggyu Lim \email{hglim83@gmail.com}
}
