% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projectSummaryMaxSurface.R
\name{projectSummaryMaxSurface}
\alias{projectSummaryMaxSurface}
\title{Project probability-of-origin surfaces into one summary surface.}
\usage{
projectSummaryMaxSurface(surfaces, nClust = FALSE)
}
\arguments{
\item{surfaces}{Object of class "RasterStack", where each layer represents a probability-of-origin surface}

\item{nClust}{Create and apply a multi-core cluster for faster processing using `raster` and `parallel` packages. Defaults to `FALSE` (i.e., no clustering).}
}
\description{
Create a summary surface showing which RasterLayer in a Stack has the highest value at a given location.
For each cell in a RasterStack, this function returns the identity of the RasterLayer with the highest value at that cell.
This surface is intended as a visual summary of common origins, not a basis for quantitative analysis.
}
\examples{
# Create and cluster example assignment surfaces.
myiso <- rasterFromXYZ(isoscape)
myiso_sd <- rasterFromXYZ(isoscape_sd)
assignmentModels <- isotopeAssignmentModel(
        ID = LETTERS[1:4],
        isotopeValue = seq(-120,-25,length.out = 4),
        SD_indv = rep(5,4),
        precip_raster = myiso,
        precip_SD_raster = myiso_sd,
        nClusters = FALSE
        )
raster::plot(assignmentModels)

# Project mean aggregate surfaces into space.
summaryMap <- projectSummaryMaxSurface(
        surfaces = assignmentModels,
        nClust = FALSE
        )
raster::plot(summaryMap)

}
