% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ternary_segments.R
\docType{methods}
\name{ternary_segments}
\alias{ternary_segments}
\alias{ternary_segments-method}
\alias{ternary_segments,numeric,numeric,numeric-method}
\title{Add Line Segments to a Ternary Plot}
\usage{
ternary_segments(x0, y0, z0, ...)

\S4method{ternary_segments}{numeric,numeric,numeric}(x0, y0, z0, x1 = x0, y1 = y0, z1 = z0, ...)
}
\arguments{
\item{x0, y0, z0}{A \code{\link{numeric}} vector giving the x, y and z ternary
coordinates of points from which to draw.}

\item{...}{Further graphical parameters (see \code{\link[graphics:par]{graphics::par()}}) may also be
supplied as arguments, particularly, line type, \code{lty}, line width, \code{lwd} and
color, \code{col}. Also the line characteristics \code{lend}, \code{ljoin} and \code{lmitre}.}

\item{x1, y1, z1}{A \code{\link{numeric}} vector giving the x, y and z ternary
coordinates of points to which to draw.}
}
\value{
\code{ternary_segments()} is called it for its side-effects.
}
\description{
Draw line segments between pairs of points.
}
\examples{
## Add segments
ternary_plot(NULL, panel.first = ternary_grid())
ternary_segments(x0 = 40, y0 = 20, z0 = 40,
                 x1 = 20, y1 = 40, z1 = 40)
}
\seealso{
\code{\link[graphics:segments]{graphics::segments()}}

Other geometries: 
\code{\link{ternary_arrows}()},
\code{\link{ternary_crosshairs}()},
\code{\link{ternary_labels}()},
\code{\link{ternary_lines}()},
\code{\link{ternary_points}()},
\code{\link{ternary_polygon}()},
\code{\link{ternary_text}()}
}
\author{
N. Frerebeau
}
\concept{geometries}
