% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_run-mcmc.R
\name{run_mcmc}
\alias{run_mcmc}
\title{Run a MCMC sampler on a network model using Stan}
\usage{
run_mcmc(model, iter = 2000, chains = 4, cores = NULL, stanfit = FALSE, ...)
}
\arguments{
\item{model}{A \code{networkModel}.}

\item{iter}{A positive integer specifying the number of iterations for each
chain (including warmup). The default is 2000.}

\item{chains}{A positive integer specifying the number of Markov chains.
The default is 4.}

\item{cores}{Number of cores to sue for parallel use. Default is
\code{NULL}, which means to use the value stored in
\code{options()[["mc.cores"]]} (or 1 if this value is not set).}

\item{stanfit}{If TRUE, returns a `stanfit` object instead of the more
classical `mcmc.list` object.}

\item{...}{Arguments passed to `rstan::sampling` (e.g. iter, chains).}
}
\value{
An object of class `stanfit` returned by `rstan::sampling`.
}
\description{
Run a MCMC sampler on a network model using Stan
}
