% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_predictions.R
\name{tidy_mcmc}
\alias{tidy_mcmc}
\title{Extract a tidy output from an mcmc.list}
\usage{
tidy_mcmc(x, spread = FALSE, include_constant = TRUE)
}
\arguments{
\item{x}{An mcmc.list object}

\item{spread}{Boolean, spread the parameters into separate columns?}

\item{include_constant}{Boolean, include constant parameters as proper
parameter traces?}
}
\value{
A tidy table containing one iteration per row
}
\description{
Extract a tidy output from an mcmc.list
}
\examples{
fit <- lapply(1:4, function(i) {
  z <- matrix(rnorm(200), ncol = 2)
  colnames(z) <- c("alpha", "beta")
  coda::as.mcmc(z)
})
fit <- coda::as.mcmc.list(fit)
tidy_mcmc(fit)
tidy_mcmc(fit, spread = TRUE)

}
