% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itcIMG.R
\name{itcIMG}
\alias{itcIMG}
\title{Individual Tree Crowns segmentation with imagery data}
\usage{
itcIMG(imagery = NULL, epsg = NULL, searchWinSize = 3, TRESHSeed = 0.45,
  TRESHCrown = 0.55, DIST = 10, th = 0, ischm = FALSE)
}
\arguments{
\item{imagery}{An object of class raster on which to perform the segmentation. The image should be projected.}

\item{epsg}{The EPSG code of the reference system of the image.}

\item{searchWinSize}{Size (in pixels) of the moving window used to the detect the local maxima. It should be an odd number larger than 3.}

\item{TRESHSeed}{Growing threshold 1. It should be between 0 and 1.}

\item{TRESHCrown}{Growing threshold 2. It should be between 0 and 1.}

\item{DIST}{Maximum value of the crown diameter of a detected tree (in meters).}

\item{th}{Digital number value below which a pixel cannot be a local maxima.}

\item{ischm}{TRUE if the imagery is a Canopy Height Model (CHM). Default: FALSE.}
}
\value{
An object of the class SpatialPolygonsDataFrame containing the delineated ITCs. The informaion for each ITC contained in the data frame are the X and Y coordinates position of the tree, the tree height in meters (Height_m;  only if ischm=TRUE) and its crown area in square meters (CA_m2).
}
\description{
The ITC delineation approach finds local maxima within an imagery, designates these as tree tops, then uses a decision tree method to grow individual crowns around the local maxima.
}
\examples{
\dontrun{
data(imgData)

se<-itcIMG(imgData,epsg=32632)
summary(se)
plot(se,axes=T)

## to save the data use rgdal function called writeOGR. For more help see rgdal package.

}
}
\references{
M. Dalponte, F. Reyes, K. Kandare, and D. Gianelle, "Delineation of Individual Tree Crowns from ALS and Hyperspectral data: a comparison among four methods," European Journal of Remote Sensing, Vol. 48, pp. 365-382, 2015.
}
\author{
Michele Dalponte
}
