% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{write_raw}
\alias{write_raw}
\title{Write raw data into files}
\usage{
write_raw(object, dir, title)
}
\arguments{
\item{object}{itol.hub object holds the complete data and theme information.
This is an all-in-one object that collects all the information. Based on this
object, it is possible to export template files directly. It can also be
converted to an operation unit object for the detailed processing of
individual datasets. The object can also be saved locally for reproducible
visualization to share. This object contains species or sample clustering
trees, sequence alignment, species abundance or gene expression table,
multi-level taxonomic information, metadata, and a list of custom themes.
Each element name in the theme list is prefixed with the column name of the
metadata and is used to establish the association between the theme and the
data. For some special dataset types, the storage location is not in the
metadata, but it also conforms to the association with themes. The program
automatically decides where to read the data according to the different
output template types. The user only needs to explicitly define the theme
name to be output consistent with the data name prefix.}

\item{dir}{output dir path. Define the output files location using absolute
or relative path. The raw data will write into files. The following raw data
will be outputted: main tree, sample tree, alignment sequences, abundance
count table, taxonomy table, metadata on nodes and tips.}

\item{title}{files name title string. This character specified the prefix of
raw data files.}
}
\value{
No return value, only output raw data files
}
\description{
Write raw data in itol.hub object into files
}
\examples{
tree <- system.file("extdata",
                    "tree_of_itol_templates.tree",
                    package = "itol.toolkit")
hub <- create_hub(tree = tree)
df_values <- data.table::fread(system.file("extdata",
                                           "templates_frequence.txt",
                                           package = "itol.toolkit"))
unit <- create_unit(data = df_values,
                    key = "Quickstart",
                    type = "DATASET_HEATMAP",
                    tree = tree)
hub <- hub + unit
write_raw(hub,tempdir(),"Quickstart")
}
