% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itpPrint.R
\name{print.itp}
\alias{print.itp}
\title{Print method for objects of class \code{"itp"}}
\usage{
\method{print}{itp}(x, all = FALSE, digits = max(3L, getOption("digits") - 3L), ...)
}
\arguments{
\item{x}{An object inheriting from class \code{"itp"}, a result of a
call to \code{\link{itp}}.}

\item{all}{A logical scalar.  If \code{all = FALSE} then only the estimated
root, the value of the function at the root an the number of iterations
are printed.  If \code{all = TRUE} then, in addition, the final bracketing
interval [\code{a, b}], the values of the function at the end points of
this interval and the estimated precision are printed.}

\item{digits}{The argument \code{digits} passed to \code{\link{format}}
to set the number of significant digits to print.}

\item{...}{Further arguments to be passed to or from other methods. They are
ignored in this function..}
}
\value{
The argument \code{x} is returned, invisibly.
}
\description{
Prints objects of class \code{"itp"} returned from \code{\link{itp}}.
}
\details{
The default setting is to print only the root, the value of the
  function at the root and the number of iterations.  To include the
  bracketing interval after convergence and the estimated precision use
  \code{all = TRUE}.
}
\seealso{
\code{\link{itp}} for the Interpolate, Truncate, Project (ITP) root
  finding algorithm.
}
