% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{corfit}
\alias{corfit}
\title{Calculate the correlation between the fitted model and data.}
\usage{
corfit(model)
}
\arguments{
\item{model}{A fitted regression model (using gam, or bam).}
}
\value{
Numeric value: correlation between fitted model and data.
}
\description{
Calculate the correlation between the fitted model and data.
}
\examples{
data(simdat)

# Fit simple GAM model:
gam1 <- bam(Y ~ s(Time), data=simdat, discrete=TRUE)
corfit(gam1)

}
\seealso{
Other Utility functions: 
\code{\link{convertNonAlphanumeric}()},
\code{\link{diff_terms}()},
\code{\link{find_difference}()},
\code{\link{missing_est}()},
\code{\link{modeledf}()},
\code{\link{observations}()},
\code{\link{print_summary}()},
\code{\link{refLevels}()},
\code{\link{res_df}()},
\code{\link{summary_data}()},
\code{\link{timeBins}()}
}
\concept{Utility functions}
