% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lp.R
\name{lpSetup}
\alias{lpSetup}
\title{Constructing LP problem}
\usage{
lpSetup(sset, mbA = NULL, mbs = NULL, mbrhs = NULL, lpsolver,
  shape = TRUE)
}
\arguments{
\item{sset}{List of IV-like estimates and the corresponding gamma
terms.}

\item{mbA}{Matrix used to define the constraints in the LP problem.}

\item{mbs}{Vector of model sense/inequalities signs used to define
the constraints in the LP problem.}

\item{mbrhs}{Vector of constants used to define the constraints in
the LP problem.}

\item{lpsolver}{string, name of the package used to solve the LP
problem.}

\item{shape}{boolean, default set to TRUE. Switch to determine
whether or not to include shape restrictions in the LP problem.}
}
\value{
A list of matrices and vectors necessary to define an LP
    problem for Gurobi.
}
\description{
This function takes in the IV estimates from the set of IV
regressions declared by the user, as well as their corresponding
moments of the terms in the MTR. These are then used to construct
the components that make up the LP problem. Additional constraint
matrix is added using \code{mbA} (\code{mb} stands for
"monotonicity/boundedness"); extra model sense is added using
\code{mbs}; extra RHS values added using \code{mbrhs}). Depending
on the linear programming solver used, this function will return
different output specific to the solver.
}
\examples{
## Declare empty list to be updated (in the event multiple IV like
## specifications are provided
sSet <- list()

## Declare MTR formulas
formula1 = ~ 1 + u
formula0 = ~ 1 + u

## Construct object that separates out non-spline components of MTR
## formulas from the spline components. The MTR functions are
## obtained from this object by the function 'genSSet'.
splinesList = list(removeSplines(formula0), removeSplines(formula1))

## Construct MTR polynomials
polynomials0 <- polyparse(formula = formula0,
                 data = dtm,
                 uname = u,
                 as.function = FALSE)
polynomials1 <- polyparse(formula = formula0,
                 data = dtm,
                 uname = u,
                 as.function = FALSE)

## Generate propensity score model
propensityObj <- propensity(formula = d ~ z,
                            data = dtm,
                            link = "linear")

## Generate target gamma moments
ivEstimates <- ivEstimate(formula = ey ~ d | z,
                          data = dtm,
                          components = l(intercept, d),
                          treat = d,
                          list = FALSE)

## Construct S-set, which contains the coefficients and weights
## corresponding to various IV-like estimands
sSet <- genSSet(data = dtm,
                sset = sSet,
                sest = ivEstimates,
                splinesobj = splinesList,
                pmodobj = propensityObj$phat,
                pm0 = polynomials0,
                pm1 = polynomials1,
                ncomponents = 2,
                scount = 1,
                yvar = "ey",
                dvar = "d",
                means = TRUE)

## Construct the LP problem to be solved using lpSolveAPI
lpSetup(sset = sSet$sset, lpsolver = "lpSolveAPI")

}
