% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivo_tables.R
\encoding{UTF-8}
\name{ivo_table}
\alias{ivo_table}
\title{Create pretty frequency/contingency tables}
\usage{
ivo_table(
  df,
  extra_header = TRUE,
  exclude_missing = FALSE,
  colsums = FALSE,
  rowsums = FALSE,
  caption = NA,
  highlight_cols = NULL,
  highlight_rows = NULL,
  percent_by = NA,
  color = "darkgreen",
  font_name = "Arial",
  long_table = FALSE,
  remove_zero_rows = FALSE
)
}
\arguments{
\item{df}{A data frame with 1-4 columns}

\item{extra_header}{Should the variable name be displayed? Defaults to TRUE.}

\item{exclude_missing}{Whether to exclude missing values from the table. Defaults to FALSE.}

\item{colsums}{A logical indicating whether the sum of each column should be computed. Defaults to FALSE.}

\item{rowsums}{A logical indicating whether the sum of each row should be computed. Defaults to FALSE.}

\item{caption}{An optional string containing a table caption.}

\item{highlight_cols}{A numeric vector containing the indices of the columns that should be highlighted.}

\item{highlight_rows}{A numeric vector containing the indices of the rows that should be highlighted.}

\item{percent_by}{Used to get percentages instead of frequencies. There are three options: "row" to get percentages by row (each row sum is 100 percent), "col" to get percentages by column (each the sum of each row to 100 percent) and "tot" to get percentages out of the total (the sum of all cells is 100 percent). The default, NA, means that frequencies are displayed instead.}

\item{color}{A named color or a color HEX code, used for the lines in the table. Defaults to "darkgreen".}

\item{font_name}{The name of the font to be used in the table. Defaults to "Arial".}

\item{long_table}{For one-way tables: FALSE (the default) means that the table will be wide and consist of a single row, TRUE means that the table will be long and consist of a single column.}

\item{remove_zero_rows}{If set to TRUE, removes all rows that contain nothing but zeros. The default is FALSE.}
}
\value{
A stylized \code{flextable}.
}
\description{
\code{ivo_table()} lets you easily create a table using pretty fonts and colors. If you want the table with masked values use \code{ivo_table_masked()}.
}
\details{
The functions \code{ivo_table()} and \code{ivo_table_masked()} takes a \code{data.frame} with 1-4 columns. The order of the columns in the \code{data.frame} will determine where they will be displayed in the table. The first column will always be displayed at the top of the table. If there are more than one column the following 2-4 columns will be displayed to the left in the order 2, 3, 4. To change how the columns are displayed in the table; change the place of the columns in the \code{data.frame} using \code{dplyr::select()}.
}
\seealso{
{ivo_table_add_mask}
}
\author{
Måns Thulin and Kajsa Grind
}
