% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jabr_get_adm.R
\name{jabr_get_adm}
\alias{jabr_get_adm}
\title{Get administrative area}
\usage{
jabr_get_adm(level, code_bps)
}
\arguments{
\item{level}{Level of administrative division. Valid values are "subdisctrict" for Kecamatan and "village" for Desa/Kelurahan.}

\item{code_bps}{BPS code of the upper administrative division. To get "subdistrict" level area, you have to supply the BPS code of the district (Kota/Kabupaten). To get "village" level area, you have to supply the BPS code of the subdistrict (Kecamatan).}
}
\value{
A tibble.
}
\description{
List the administrative area of Jawa Barat.
}
\examples{
\donttest{
library(jabr)

jabar_district

jabr_get_adm(level = "subdistrict", code_bps = "3209")
}

}
